import * as React from "react";
import { CarouselInternalState, CarouselProps, StateCallBack, Direction, SkipCallbackOptions } from "./types";
declare class Carousel extends React.Component<CarouselProps, CarouselInternalState> {
    static defaultProps: {
        slidesToSlide: number;
        infinite: boolean;
        draggable: boolean;
        swipeable: boolean;
        arrows: boolean;
        renderArrowsWhenDisabled: boolean;
        containerClass: string;
        sliderClass: string;
        itemClass: string;
        keyBoardControl: boolean;
        autoPlaySpeed: number;
        showDots: boolean;
        renderDotsOutside: boolean;
        renderButtonGroupOutside: boolean;
        minimumTouchDrag: number;
        className: string;
        dotListClass: string;
        focusOnSelect: boolean;
        centerMode: boolean;
        additionalTransfrom: number;
        pauseOnHover: boolean;
        shouldResetAutoplay: boolean;
        rewind: boolean;
        rtl: boolean;
        rewindWithAnimation: boolean;
    };
    private readonly containerRef;
    private readonly listRef;
    onMove: boolean;
    initialX: number;
    lastX: number;
    isAnimationAllowed: boolean;
    direction: Direction;
    autoPlay?: any;
    isInThrottle?: boolean;
    initialY: number;
    private transformPlaceHolder;
    private itemsToShowTimeout;
    static clonesTimeout: any;
    static isInThrottleTimeout: any;
    static transformTimeout: any;
    static afterChangeTimeout: any;
    static afterChangeTimeout2: any;
    static afterChangeTimeout3: any;
    constructor(props: CarouselProps);
    resetTotalItems(): void;
    setIsInThrottle(isInThrottle?: boolean): void;
    setTransformDirectly(position: number, withAnimation?: boolean): void;
    setAnimationDirectly(animationAllowed?: boolean): void;
    componentDidMount(): void;
    setClones(slidesToShow: number, itemWidth?: number, forResizing?: boolean, resetCurrentSlide?: boolean): void;
    setItemsToShow(shouldCorrectItemPosition?: boolean, resetCurrentSlide?: boolean): void;
    setContainerAndItemWidth(slidesToShow: number, shouldCorrectItemPosition?: boolean, resetCurrentSlide?: boolean): void;
    correctItemsPosition(itemWidth: number, isAnimationAllowed?: boolean, setToDomDirectly?: boolean): void;
    onResize(value?: React.KeyboardEvent | boolean): void;
    componentDidUpdate({ keyBoardControl, autoPlay, children }: CarouselProps, { containerWidth, domLoaded, currentSlide }: CarouselInternalState): void;
    correctClonesPosition({ domLoaded }: {
        domLoaded?: boolean;
    }): void;
    next(slidesHavePassed?: number): void;
    previous(slidesHavePassed?: number): void;
    resetAutoplayInterval(): void;
    componentWillUnmount(): void;
    resetMoveStatus(): void;
    getCords({ clientX, clientY }: {
        clientX: number;
        clientY: number;
    }): {
        clientX: number;
        clientY: number;
    };
    handleDown(e: React.MouseEvent | React.TouchEvent): void;
    handleMove(e: React.MouseEvent | React.TouchEvent): void;
    handleOut(e: React.MouseEvent | React.TouchEvent): void;
    private isInViewport;
    private isChildOfCarousel;
    onKeyUp(e: React.KeyboardEvent): void;
    handleEnter(e: React.MouseEvent): void;
    goToSlide(slide: number, skipCallbacks?: SkipCallbackOptions, animationAllowed?: boolean): void;
    getState(): StateCallBack;
    renderLeftArrow(disbaled: boolean): React.ReactNode;
    renderRightArrow(disbaled: boolean): React.ReactNode;
    renderButtonGroups(): React.ReactElement<any> | null;
    renderDotsList(): React.ReactElement<any> | null;
    renderCarouselItems(): JSX.Element;
    render(): React.ReactNode;
}
export default Carousel;
