/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/search
 */
import type { ICreate, IJodit, ISelectionRange } from "../../../types/index";
/**
 * @private
 */
export declare function highlightTextRanges(jodit: IJodit, rng: ISelectionRange, restRanges: ISelectionRange[], ci: ICreate, root: HTMLElement): void;
/**
 * @private
 */
export declare function getSelectionWrappers(root: HTMLElement): HTMLElement[];
/**
 * @private
 */
export declare function clearSelectionWrappers(jodit: IJodit): void;
/**
 * @private
 */
export declare function clearSelectionWrappersFromHTML(root: string): string;
export declare function clearNativeSelection(jodit: IJodit): void;
