/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:plugins/ai-assistant/README.md]]
 * @packageDocumentation
 * @module plugins/ai-assistant
 */
import type { IJodit } from "../../types/index";
import { Plugin } from "../../core/plugin/plugin";
import "./config";
/**
 * The plugin inserts content generated by AI into the editor.
 */
export declare class aiAssistant extends Plugin {
    /** @override */
    buttons: Plugin['buttons'];
    private get __dialog();
    private get __container();
    constructor(jodit: IJodit);
    /** @override */
    afterInit(): void;
    protected onGenerateAiAssistantForm(prompt: string): void;
    protected onInvokeAiAssistant(prompt: string): void;
    /** @override */
    protected beforeDestruct(_: IJodit): void;
}
