/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/toolbar/button/README.md]]
 * @packageDocumentation
 * @module modules/toolbar/button
 */
import type { IControlTypeStrong, IToolbarButton, IToolbarCollection, IViewBased, Nullable } from "../../../types/index";
import { UIButton } from "../../../core/ui/button/index";
export declare class ToolbarButton<T extends IViewBased = IViewBased> extends UIButton implements IToolbarButton {
    readonly control: IControlTypeStrong;
    readonly target: Nullable<HTMLElement>;
    /** @override */
    className(): string;
    readonly state: {
        theme: string;
        currentValue: string;
        hasTrigger: boolean;
        size: "tiny" | "xsmall" | "small" | "middle" | "large";
        name: string;
        value: string | number | boolean;
        variant: import("../../../types/index").ButtonVariant;
        type: "button" | "submit";
        role: "button" | "tab";
        disabled: boolean;
        activated: boolean;
        icon: import("../../../types/index").IUIIconState;
        text: string;
        tooltip: string;
        tabIndex: import("../../../types/index").CanUndef<number>;
    };
    protected trigger: HTMLElement;
    /**
     * Get parent toolbar
     */
    protected get toolbar(): Nullable<IToolbarCollection>;
    /** @override **/
    update(): void;
    /**
     * Calculates whether the button is active
     */
    private __calculateActivatedStatus;
    /**
     * Calculates whether an element is blocked for the user
     */
    private __calculateDisabledStatus;
    /** @override */
    protected onChangeActivated(): void;
    /** @override */
    protected onChangeText(): void;
    /** @override */
    protected onChangeTabIndex(): void;
    protected createContainer(): HTMLElement;
    /** @override */
    focus(): void;
    protected onChangeHasTrigger(): void;
    /** @override */
    protected onChangeDisabled(): void;
    constructor(jodit: T, control: IControlTypeStrong, target?: Nullable<HTMLElement>);
    /**
     * Init constant data from control
     */
    protected __initFromControl(): void;
    /**
     * Click on trigger button
     */
    protected onTriggerClick(e: MouseEvent): void;
    private openedPopup;
    /**
     * Create an open popup list
     */
    private __openControlList;
    protected onOutsideClick(e: MouseEvent): void;
    private openPopup;
    private __closePopup;
    /**
     * Click handler
     */
    protected onClick(originalEvent: MouseEvent): void;
    destruct(): any;
}
