/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
import { call, convertMediaUrlToVideoEmbed } from "../../core/helpers/index.js";
import { Button } from "../../core/ui/button/index.js";
import { UIBlock, UIForm, UIInput, UITextArea } from "../../core/ui/form/index.js";
import { Icon } from "../../core/ui/icon.js";
import { Config } from "../../config.js";
import { TabsWidget } from "../../modules/widget/index.js";
import videoIcon from "./video.svg.js";
Config.prototype.video = {
    parseUrlToVideoEmbed: convertMediaUrlToVideoEmbed,
    defaultWidth: 400,
    defaultHeight: 345
};
Icon.set('video', videoIcon);
Config.prototype.controls.video = {
    popup: (jodit, current, close) => {
        const formLink = new UIForm(jodit, [
            new UIBlock(jodit, [
                new UIInput(jodit, {
                    name: 'url',
                    required: true,
                    label: 'URL',
                    placeholder: 'https://',
                    validators: ['url']
                })
            ]),
            new UIBlock(jodit, [
                Button(jodit, '', 'Insert', 'primary').onAction(() => formLink.submit())
            ])
        ]), formCode = new UIForm(jodit, [
            new UIBlock(jodit, [
                new UITextArea(jodit, {
                    name: 'code',
                    required: true,
                    label: 'Embed code'
                })
            ]),
            new UIBlock(jodit, [
                Button(jodit, '', 'Insert', 'primary').onAction(() => formCode.submit())
            ])
        ]), tabs = [], insertCode = (code) => {
            jodit.s.restore();
            jodit.s.insertHTML(code);
            close();
        };
        jodit.s.save();
        tabs.push({
            icon: 'link',
            name: 'Link',
            content: formLink.container
        }, {
            icon: 'source',
            name: 'Code',
            content: formCode.container
        });
        formLink.onSubmit(data => {
            var _a, _b, _c, _d;
            insertCode(call((_b = (_a = jodit.o.video) === null || _a === void 0 ? void 0 : _a.parseUrlToVideoEmbed) !== null && _b !== void 0 ? _b : convertMediaUrlToVideoEmbed, data.url, {
                width: (_c = jodit.o.video) === null || _c === void 0 ? void 0 : _c.defaultWidth,
                height: (_d = jodit.o.video) === null || _d === void 0 ? void 0 : _d.defaultHeight
            }));
        });
        formCode.onSubmit(data => {
            insertCode(data.code);
        });
        return TabsWidget(jodit, tabs);
    },
    tags: ['iframe'],
    tooltip: 'Insert youtube/vimeo video'
};
