/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
import { isArray } from "../../helpers/checker/is-array.js";
/**
 * @private
 */
export const isButtonGroup = (item) => {
    return isArray(item.buttons);
};
/**
 * @private
 */
export function flatButtonsSet(buttons, jodit) {
    const groups = jodit.getRegisteredButtonGroups();
    return new Set(buttons.reduce((acc, item) => {
        var _a;
        if (isButtonGroup(item)) {
            acc = acc.concat([
                ...item.buttons,
                ...((_a = groups[item.group]) !== null && _a !== void 0 ? _a : [])
            ]);
        }
        else {
            acc.push(item);
        }
        return acc;
    }, []));
}
