/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
import { isFunction } from "../checker/is-function.js";
export const keepNames = new Map();
export const getClassName = (obj) => {
    var _a;
    if (isFunction(obj.className)) {
        return obj.className();
    }
    const constructor = ((_a = obj.constructor) === null || _a === void 0 ? void 0 : _a.originalConstructor) || obj.constructor;
    if (keepNames.has(constructor)) {
        return keepNames.get(constructor);
    }
    if (constructor.name) {
        return constructor.name;
    }
    const regex = new RegExp(/^\s*function\s*(\S*)\s*\(/);
    const res = constructor.toString().match(regex);
    return res ? res[1] : '';
};
