import React from 'react';
import type { IJodit } from 'jodit/esm/types/jodit';
import type { Jodit as JoditBaseConstructor } from 'jodit/esm/index';
import type { Config } from 'jodit/esm/config';
import { Jodit } from './include.jodit';
import type { DeepPartial } from 'jodit/esm/types';
interface Props<T extends typeof JoditBaseConstructor = typeof Jodit> {
    JoditConstructor?: T;
    config?: DeepPartial<Config>;
    className?: string;
    id?: string;
    name?: string;
    onBlur?: (value: string, event: MouseEvent) => void;
    onChange?: (value: string) => void;
    tabIndex?: number;
    value?: string;
    editorRef?: (editor: IJodit) => void;
}
declare const JoditEditor: React.ForwardRefExoticComponent<Props<typeof JoditBaseConstructor> & React.RefAttributes<IJodit>>;
export default JoditEditor;
