import PrismaDefault from "@prisma/client/scripts/default-index.js";
/**
 * Generates a User-Agent string derived from the current execution environment.
 */
export function getUserAgent() {
    const prismaVersion = PrismaDefault.Prisma.prismaVersion;
    const parts = [
        getRuntimeSegment(),
        `PrismaEngine/${prismaVersion.engine}`,
        `PrismaClient/${prismaVersion.client}`,
    ];
    return parts.join(" ");
}
/**
 * Generates a User-Agent segment for the JavaScript runtime environment.
 */
function getRuntimeSegment() {
    if (typeof navigator !== "undefined") {
        // Deno, Bun, Cloudflare Workers, general WinterCG compat
        return navigator.userAgent;
    }
    else if (typeof process !== "undefined" &&
        typeof process.versions !== "undefined") {
        return `Node/${process.versions.node} (${process.platform}; ${process.arch})`;
    }
    else if ("EdgeRuntime" in globalThis) {
        return `Vercel-Edge-Runtime`;
    }
    else {
        return `UnknownRuntime`;
    }
}
