/**
 * Compares two SemVer strings.
 * @returns positive if b > a, negative if b < a, and 0 if versions are equal
 */
export function compareSemVer(a, b) {
    const [major1 = 0, minor1 = 0, patch1 = 0] = a.split(".").map(Number);
    const [major2 = 0, minor2 = 0, patch2 = 0] = b.split(".").map(Number);
    const major = major2 - major1;
    const minor = minor2 - minor1;
    const patch = patch2 - patch1;
    return major || minor || patch;
}
