/// <reference lib="dom" />
export type FetchOptions = {
    method?: string;
    headers?: Record<string, string>;
    body?: string;
};
export type RequestResponse = {
    body?: {
        cancel(): Promise<void>;
    } | null;
    ok: boolean;
    url: string;
    statusText?: string;
    status: number;
    headers: Headers;
    text: () => Promise<string>;
    json: () => Promise<any>;
};
/**
 * Imitates `fetch` via `https` to only suit our needs, it does nothing more.
 * This is because we cannot bundle `node-fetch` as it uses many other Node.js
 * utilities, while also bloating our bundles. This approach is much leaner.
 * @param url
 * @param options
 * @returns
 */
export declare function fetch(url: string, options?: FetchOptions): Promise<RequestResponse>;
