"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUserAgent = void 0;
const default_index_js_1 = __importDefault(require("@prisma/client/scripts/default-index.js"));
/**
 * Generates a User-Agent string derived from the current execution environment.
 */
function getUserAgent() {
    const prismaVersion = default_index_js_1.default.Prisma.prismaVersion;
    const parts = [
        getRuntimeSegment(),
        `PrismaEngine/${prismaVersion.engine}`,
        `PrismaClient/${prismaVersion.client}`,
    ];
    return parts.join(" ");
}
exports.getUserAgent = getUserAgent;
/**
 * Generates a User-Agent segment for the JavaScript runtime environment.
 */
function getRuntimeSegment() {
    if (typeof navigator !== "undefined") {
        // Deno, Bun, Cloudflare Workers, general WinterCG compat
        return navigator.userAgent;
    }
    else if (typeof process !== "undefined" &&
        typeof process.versions !== "undefined") {
        return `Node/${process.versions.node} (${process.platform}; ${process.arch})`;
    }
    else if ("EdgeRuntime" in globalThis) {
        return `Vercel-Edge-Runtime`;
    }
    else {
        return `UnknownRuntime`;
    }
}
