"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _NodeHeaders_headers;
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetch = void 0;
const node_https_1 = __importDefault(require("node:https"));
/**
 * Imitates `fetch` via `https` to only suit our needs, it does nothing more.
 * This is because we cannot bundle `node-fetch` as it uses many other Node.js
 * utilities, while also bloating our bundles. This approach is much leaner.
 * @param url
 * @param options
 * @returns
 */
async function fetch(url, options = {}) {
    const httpsOptions = buildOptions(options);
    const incomingData = new Array();
    const { origin } = new URL(url);
    return new Promise((resolve, reject) => {
        // we execute the https request and build a fetch response out of it
        const request = node_https_1.default.request(url, httpsOptions, (response) => {
            const { statusCode = 200, headers: { location }, } = response;
            if (statusCode >= 301 && statusCode <= 399 && location) {
                if (location.startsWith("http") === false) {
                    resolve(fetch(`${origin}${location}`, options));
                }
                else {
                    resolve(fetch(location, options));
                }
            }
            response.on("data", (chunk) => incomingData.push(chunk));
            response.on("end", () => resolve(buildResponse(incomingData, response)));
            response.on("error", reject);
        });
        request.on("error", reject);
        request.end(options.body ?? "");
    });
}
exports.fetch = fetch;
/**
 * Build http headers from fetch-like headers
 * @param options
 * @returns
 */
function buildHeaders(options) {
    return {
        ...options.headers,
        "Content-Type": "application/json",
    };
}
/**
 * Build http options from fetch-like options
 * @param options
 * @returns
 */
function buildOptions(options) {
    return {
        method: options.method,
        headers: buildHeaders(options),
    };
}
/**
 * Build a fetch-like response from an http response
 * @param incomingData
 * @param response
 * @returns
 */
function buildResponse(incomingData, response) {
    const { statusCode = 200, url, headers } = response;
    return {
        body: {
            cancel() {
                return Promise.resolve();
            },
        },
        text: () => Promise.resolve(Buffer.concat(incomingData).toString()),
        json: () => Promise.resolve(JSON.parse(Buffer.concat(incomingData).toString())),
        ok: statusCode >= 200 && statusCode <= 299,
        status: statusCode,
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        url: url,
        headers: new NodeHeaders(headers),
    };
}
class NodeHeaders {
    constructor(init = {}) {
        _NodeHeaders_headers.set(this, new Map());
        for (const [key, value] of Object.entries(init)) {
            if (typeof value === "string") {
                __classPrivateFieldGet(this, _NodeHeaders_headers, "f").set(key, value);
            }
            else if (Array.isArray(value)) {
                for (const val of value) {
                    __classPrivateFieldGet(this, _NodeHeaders_headers, "f").set(key, val);
                }
            }
        }
    }
    append(name, value) {
        __classPrivateFieldGet(this, _NodeHeaders_headers, "f").set(name, value);
    }
    delete(name) {
        __classPrivateFieldGet(this, _NodeHeaders_headers, "f").delete(name);
    }
    get(name) {
        return __classPrivateFieldGet(this, _NodeHeaders_headers, "f").get(name) ?? null;
    }
    getSetCookie() {
        throw new Error("Method not implemented.");
    }
    has(name) {
        return __classPrivateFieldGet(this, _NodeHeaders_headers, "f").has(name);
    }
    set(name, value) {
        __classPrivateFieldGet(this, _NodeHeaders_headers, "f").set(name, value);
    }
    forEach(callbackfn, thisArg) {
        for (const [key, value] of __classPrivateFieldGet(this, _NodeHeaders_headers, "f")) {
            callbackfn.call(thisArg, value, key, this);
        }
    }
}
_NodeHeaders_headers = new WeakMap();
