/// <reference lib="dom" />
import PrismaDefault, { type Prisma } from "@prisma/client/scripts/default-index.js";
import type { Types } from "@prisma/client/runtime/library.js";
import type { RequestResponse } from "./node-fetch.js";
export declare const FETCH_FAILURE_MESSAGE = "Unable to connect to the Accelerate API. This may be due to a network or DNS issue. Please check your connection and the Accelerate connection string. For details, visit https://www.prisma.io/docs/accelerate/troubleshoot.";
export interface PrismaCacheStrategy {
    /**
     * Specifies the caching parameters for Accelerate.
     *
     * `cacheStrategy` only applies when used with an Accelerate connection string.
     */
    readonly cacheStrategy?: {
        /**
         * `swr` is short for Stale-While-Revalidate.
         *
         * `swr` defines the number of seconds that Accelerate may serve _stale_ cache data.
         * _Stale_ data is a cache hit, but the cache will be refreshed in the background by Accelerate.
         * The Prisma operation will not be blocked while data is refreshed.
         *
         * Use `swr` to reduce the latency of accessing the data while still maintaining
         * a more up-to-date value in the Accelerate cache.
         * `swr` without `ttl` will not reduce database load since Accelerate will
         * run the query in the background.
         *
         * `swr` can be combined with `ttl`.
         * `swr` applies **after** `ttl` has expired.
         * The total number of seconds data will be cached is `ttl + swr`.
         *
         * `swr` only applies when used with an Accelerate connection string.
         */
        readonly swr?: number;
        /**
         * `ttl` is short for Time-to-Live.
         *
         * `ttl` defines the number of seconds that Accelerate may serve _fresh_ cache data.
         * _Fresh_ data is a cache hit and will not execute the query against the database.
         *
         * Use `ttl` to reduce database load and latency for data that does not
         * require frequent updates.
         * `ttl` without `swr` will incur a blocking database query for the first
         * request after `ttl` expires.
         *
         * It's recommended to combine `ttl` and `swr` to maintain low latency while
         * Accelerate refreshes cached data in the background.
         * `swr` applies **after** `ttl` has expired.
         * The total number of seconds data will be cached is `ttl + swr`.
         *
         * `ttl` only applies when used with an Accelerate connection string.
         */
        readonly ttl?: number;
        /**
         * `tags` allow you to attach string values to the query's cache entry
         * that can later be used to invalidate the cache.
         *
         * A tag may only contain alphanumeric characters and underscores.
         * Each tag may contain a maximum of 64 characters.
         * A maximum of 5 tags are allowed per query.
         */
        readonly tags?: ReadonlyArray<string>;
    };
}
type PrismaFetch = (url: string, options: {
    body?: string;
    method?: string;
    headers: Record<string, string>;
}) => Promise<RequestResponse>;
export interface AccelerateInfo {
    /**
     * The cache status of the response.
     * * `ttl` indicates a cache hit within the `ttl` duration and no database query was executed
     * * `swr` indicates a cache hit within the `swr` duration and the data is being refreshed by Accelerate in the background
     * * `miss` indicates that both `ttl` and `swr` have expired and the database query was executed by the request
     * * `none` indicates that no cache strategy was specified and the database query was executed by the request
     */
    cacheStatus: "ttl" | "swr" | "miss" | "none";
    /**
     * The date the response was last refreshed.
     */
    lastModified: Date;
    /**
     * The datacenter region that received the request.
     */
    region: string;
    /**
     * Unique identifier of the request. Useful for troubleshooting.
     */
    requestId: string;
    /**
     * The unique signature of the Prisma operation.
     */
    signature: string;
}
export type AccelerateInvalidateInput = {
    /** Invalidate cache by tags set in the query `cacheStrategy`. */
    tags: ReadonlyArray<string>;
};
export interface AcceleratePromise<T> extends Prisma.PrismaPromise<T> {
    withAccelerateInfo(): Prisma.PrismaPromise<{
        data: T;
        info: AccelerateInfo | null;
    }>;
}
export declare function makeAccelerateExtension(fetcher: PrismaFetch): (client: any) => PrismaDefault.PrismaClientExtends<Types.Extensions.InternalArgs<{}, {
    $allModels: {
        aggregate<T, A>(this: T, args: Prisma.Exact<A, Prisma.Args<T, "aggregate"> & PrismaCacheStrategy>): AcceleratePromise<Prisma.Result<T, A, "aggregate">>;
        count<T_1, A_1>(this: T_1, args?: Prisma.Exact<A_1, Prisma.Args<T_1, "count"> & PrismaCacheStrategy> | undefined): AcceleratePromise<Prisma.Result<T_1, A_1, "count">>;
        findFirst<T_2, A_2>(this: T_2, args?: Prisma.Exact<A_2, Prisma.Args<T_2, "findFirst"> & PrismaCacheStrategy> | undefined): AcceleratePromise<Prisma.Result<T_2, A_2, "findFirst"> | null>;
        findFirstOrThrow<T_3, A_3>(this: T_3, args?: Prisma.Exact<A_3, Prisma.Args<T_3, "findFirstOrThrow"> & PrismaCacheStrategy> | undefined): AcceleratePromise<Prisma.Result<T_3, A_3, "findFirstOrThrow">>;
        findMany<T_4, A_4>(this: T_4, args?: Prisma.Exact<A_4, Prisma.Args<T_4, "findMany"> & PrismaCacheStrategy> | undefined): AcceleratePromise<Prisma.Result<T_4, A_4, "findMany">>;
        findUnique<T_5, A_5>(this: T_5, args: Prisma.Exact<A_5, Prisma.Args<T_5, "findUnique"> & PrismaCacheStrategy>): AcceleratePromise<Prisma.Result<T_5, A_5, "findUnique"> | null>;
        findUniqueOrThrow<T_6, A_6>(this: T_6, args: Prisma.Exact<A_6, Prisma.Args<T_6, "findUniqueOrThrow"> & PrismaCacheStrategy>): AcceleratePromise<Prisma.Result<T_6, A_6, "findUniqueOrThrow">>;
        groupBy<T_7, A_7>(this: T_7, args: Prisma.Exact<A_7, Prisma.Args<T_7, "groupBy"> & PrismaCacheStrategy>): AcceleratePromise<Prisma.Result<T_7, A_7, "groupBy">>;
    };
}, {}, {
    $accelerate: {
        /**
         * Initiates an invalidation request for the specified cache tag values.
         *
         * A tag may only contain alphanumeric characters and underscores.
         * Each tag may contain a maximum of 64 characters.
         * A maximum of 5 tags may be invalidated per call.
         */
        invalidate: (input: AccelerateInvalidateInput) => Promise<{
            requestId: string;
        }>;
    };
}> & Types.Extensions.InternalArgs<{}, {}, {}, {}> & Types.Extensions.DefaultArgs>;
export {};
