/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * @module utils/delay
 */
/* globals setTimeout, clearTimeout */
/**
 * Returns a function wrapper that will trigger a function after a specified wait time.
 * The timeout can be canceled by calling the cancel function on the returned wrapped function.
 *
 * @param func The function to wrap.
 * @param wait The timeout in ms.
 */
export default function delay(func, wait) {
    let timer;
    function delayed(...args) {
        delayed.cancel();
        timer = setTimeout(() => func(...args), wait);
    }
    delayed.cancel = () => {
        clearTimeout(timer);
    };
    return delayed;
}
