/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
import React, { type Dispatch, type SetStateAction, type JSX } from 'react';
import type { WatchdogConfig, MultiRootEditor, EventInfo } from 'ckeditor5';
import type { EditorSemaphoreMountResult } from './lifecycle/LifeCycleEditorSemaphore.js';
import { type LifeCycleSemaphoreSyncRefResult } from './lifecycle/useLifeCycleSemaphoreSyncRef.js';
declare const useMultiRootEditor: (props: MultiRootHookProps) => MultiRootHookReturns;
export declare const EditorEditable: React.MemoExoticComponent<React.ForwardRefExoticComponent<{
    id: string;
    rootName: string;
    semaphore: LifeCycleSemaphoreSyncRefResult<LifeCycleMountResult>;
} & React.RefAttributes<unknown>>>;
export declare const EditorToolbarWrapper: React.ForwardRefExoticComponent<Omit<any, "ref"> & React.RefAttributes<unknown>>;
export default useMultiRootEditor;
type LifeCycleMountResult = EditorSemaphoreMountResult<MultiRootEditor>;
interface ErrorDetails {
    phase: 'initialization' | 'runtime';
    willEditorRestart?: boolean;
}
export type MultiRootHookProps = {
    id?: any;
    semaphoreElement?: HTMLElement;
    isLayoutReady?: boolean;
    disabled?: boolean;
    data: Record<string, string>;
    rootsAttributes?: Record<string, Record<string, unknown>>;
    editor: typeof MultiRootEditor;
    watchdogConfig?: WatchdogConfig;
    disableWatchdog?: boolean;
    disableTwoWayDataBinding?: boolean;
    onReady?: (editor: MultiRootEditor) => void;
    onAfterDestroy?: (editor: MultiRootEditor) => void;
    onError?: (error: Error, details: ErrorDetails) => void;
    onChange?: (event: EventInfo, editor: MultiRootEditor) => void;
    onFocus?: (event: EventInfo, editor: MultiRootEditor) => void;
    onBlur?: (event: EventInfo, editor: MultiRootEditor) => void;
    config?: Record<string, unknown>;
};
export type MultiRootHookReturns = {
    editor: MultiRootEditor | null;
    editableElements: Array<JSX.Element>;
    toolbarElement: JSX.Element;
    data: Record<string, string>;
    setData: Dispatch<SetStateAction<Record<string, string>>>;
    attributes: Record<string, Record<string, unknown>>;
    setAttributes: Dispatch<SetStateAction<Record<string, Record<string, unknown>>>>;
};
