/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * Hook that guarantees that returns constant reference for passed function.
 * Useful for preventing closures from capturing cached scope variables (avoiding the stale closure problem).
 */
export declare const useRefSafeCallback: <A extends Array<unknown>, R>(fn: (...args: A) => R) => typeof fn;
