import { SemanticVersion } from './isSemanticVersion.js';
type DestructuredSemanticVersion = {
    major: number;
    minor: number;
    patch: number;
};
/**
 * Destructure a semantic version string into its major, minor, and patch components.
 *
 * @param version - The semantic version string to destructure.
 * @returns An object containing the major, minor, and patch numbers.
 * @throws Will throw an error if the provided version is not a valid semantic version.
 */
export declare function destructureSemanticVersion(version: SemanticVersion): DestructuredSemanticVersion;
export {};
