/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * Appends a `<link>` element to the `<head>` to preload a resource.
 *
 * 	* It should detect if the resource is already preloaded.
 * 	* It should detect type of the resource and set the `as` attribute accordingly.
 *
 * @param url The URL of the resource to preload.
 * @param props Additional properties for the preload.
 * @param props.attributes Additional attributes to be set on the `<link>` element.
 */
export declare function preloadResource(url: string, { attributes }?: PreloadResourceProps): void;
/**
 * Properties for the `preloadResource` function.
 */
type PreloadResourceProps = {
    attributes?: Record<string, any>;
};
export {};
