/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * Map of injected scripts. It is used to prevent injecting the same script multiple times.
 * It happens quite often in React Strict mode when the component is rendered twice.
 */
export declare const INJECTED_SCRIPTS: Map<string, Promise<void>>;
/**
 * Injects a script into the document.
 *
 * @param src The URL of the script to be injected.
 * @param props Additional properties used to decide how the script should be injected.
 * @param props.attributes Additional attributes to be set on the script element.
 * @returns A promise that resolves when the script is loaded.
 */
export declare function injectScript(src: string, { attributes }?: InjectScriptProps): Promise<void>;
/**
 * Props for the `injectScript` function.
 */
export type InjectScriptProps = {
    attributes?: Record<string, any>;
};
/**
 * Injects multiple scripts into the document in parallel.
 *
 * @param sources The URLs of the scripts to be injected.
 * @param props Additional properties used to decide how the script should be injected.
 * @returns A promise that resolves when all scripts are loaded.
 */
export declare function injectScriptsInParallel(sources: Array<string>, props?: InjectScriptProps): Promise<void>;
