import { EditorConfig, PluginConstructor } from 'ckeditor5';
/**
 * Appends plugins to the editor configuration.
 * It uses the `extraPlugins` property to append the plugins to avoid dealing with built-in constructor plugins.
 *
 * @param config The editor configuration.
 * @param plugins The plugins to append.
 * @returns The editor configuration with the plugins appended.
 * @example
 * ```ts
 * const editorConfig = appendExtraPluginsToEditorConfig(
 * 	{
 * 		extraPlugins: [ 'Plugin1' ]
 * 	},
 * 	[ 'Plugin2' ]
 * );
 *
 * console.log( editorConfig.extraPlugins ); // [ 'Plugin1', 'Plugin2' ]
 * ```
 */
export declare function appendExtraPluginsToEditorConfig(config: EditorConfig, plugins: Array<PluginConstructor>): EditorConfig;
