import { Editor } from 'ckeditor5';
/**
 * Creates a plugin that collects usage data for a specific integration.
 *
 * This part of the code is not executed in open-source implementations using a GPL key.
 * It only runs when a specific license key is provided. If you are uncertain whether
 * this applies to your installation, please contact our support team.
 *
 * @param integrationName The name of the integration.
 * @param usageData The usage data for the integration.
 * @returns The plugin that collects the usage data.
 * @example
 * ```ts
 * import { createUsageDataPlugin } from './usage-data.plugin';
 *
 * const integrationUsageDataPlugin = createUsageDataPlugin( 'react', {
 * 	version: '1.0.0',
 * 	frameworkVersion: '17.0.0'
 * } );
 *
 * const editor = ClassicEditor.create( document.querySelector( '#editor' ), {
 * 	plugins: [ integrationUsageDataPlugin ]
 * } );
 * ```
 */
export declare function createIntegrationUsageDataPlugin(integrationName: string, usageData: IntegrationUsageData): IntegrationUsageDataPlugin;
/**
 * The plugin collects usage data for an integration.
 */
export type IntegrationUsageDataPlugin = (editor: Editor) => void;
/**
 * The usage data for an integration.
 */
type IntegrationUsageData = {
    /**
     * The version of the integration.
     */
    version: string;
    /**
     * The version of the framework that the integration is using.
     */
    frameworkVersion?: string;
};
export {};
