import { SemanticVersion } from '../utils/version/isSemanticVersion.js';
/**
 * The source from which CKEditor was installed.
 */
type BundleInstallationSource = 'npm' | 'cdn';
/**
 * Information about the currently installed CKEditor.
 */
export type BundleInstallationInfo<V extends string = SemanticVersion> = {
    /**
     * The source from which CKEditor was installed.
     */
    source: BundleInstallationSource;
    /**
     * The version of CKEditor.
     */
    version: V;
};
export {};
