import { SemanticVersion } from '../../utils/version/isSemanticVersion.js';
/**
 * A version of the CKEditor that is used for testing purposes.
 */
export type CKCdnTestingVersion = 'nightly' | `nightly-${string}` | 'alpha' | 'staging' | 'internal';
/**
 * A version of a file on the CKEditor CDN.
 */
export type CKCdnVersion = SemanticVersion | CKCdnTestingVersion;
/**
 * Checks if the given string is a version of a file on the CKEditor CDN.
 *
 * @param version - The string to check.
 * @returns `true` if the string is a version of a file on the CKEditor CDN, `false` otherwise.
 * @example
 * ```ts
 * isCKCdnTestingVersion( '1.2.3-nightly-abc' ); // -> true
 * isCKCdnTestingVersion( '1.2.3-internal-abc' ); // -> true
 * isCKCdnTestingVersion( '1.2.3-alpha.1' ); // -> true
 * isCKCdnTestingVersion( '1.2.3' ); // -> false
 * isCKCdnTestingVersion( 'nightly' ); // -> true
 * isCKCdnTestingVersion( 'nightly-abc' ); // -> true
 * isCKCdnTestingVersion( 'staging' ); // -> true
 * ```
 */
export declare function isCKCdnTestingVersion(version: string | undefined): version is CKCdnTestingVersion;
/**
 * Checks if the given string is a version of a file on the CKEditor CDN.
 *
 * @param version - The string to check.
 * @returns `true` if the string is a version of a file on the CKEditor CDN, `false` otherwise.
 * @example
 * ```ts
 * isCKCdnVersion( 'nightly' ); // -> true
 * isCKCdnVersion( 'alpha' ); // -> true
 * isCKCdnVersion( 'rc-1.2.3' ); // -> true
 * isCKCdnVersion( '1.2.3' ); // -> true
 * isCKCdnVersion( 'nightly-abc' ); // -> true
 * isCKCdnVersion( 'staging' ); // -> true
 * ```
 */
export declare function isCKCdnVersion(version: string | undefined): version is CKCdnVersion;
