import { CKCdnResourcesAdvancedPack } from '../../cdn/utils/loadCKCdnResourcesPack.js';
import { CKCdnBaseBundlePackConfig } from './createCKCdnBaseBundlePack.js';
/**
 * Creates a pack of resources for the CKEditor Premium Features.
 *
 * @param config The configuration of the CKEditor Premium Features pack.
 * @returns A pack of resources for the CKEditor Premium Features.
 * @example
 *
 * ```ts
 * const { SlashCommand } = await loadCKCdnResourcesPack(
 * 	createCKCdnPremiumBundlePack( {
 * 		version: '44.0.0',
 * 		translations: [ 'es', 'de' ]
 * 	} )
 * );
 * ```
 */
export declare function createCKCdnPremiumBundlePack({ version, translations, createCustomCdnUrl }: CKCdnPremiumBundlePackConfig): CKCdnResourcesAdvancedPack<Window['CKEDITOR_PREMIUM_FEATURES']>;
/**
 * Configuration of the CKEditor Premium Features pack.
 */
export type CKCdnPremiumBundlePackConfig = Pick<CKCdnBaseBundlePackConfig, 'translations' | 'version' | 'createCustomCdnUrl'>;
