import { CKCdnResourcesAdvancedPack } from '../../cdn/utils/loadCKCdnResourcesPack.js';
import { CKCdnUrlCreator } from './createCKCdnUrl.js';
import { CKCdnVersion } from './isCKCdnVersion.js';
import './globals.js';
/**
 * Creates a pack of resources for the base CKEditor bundle.
 *
 * @param config The configuration of the CKEditor Premium Features pack.
 * @returns A pack of resources for  the base CKEditor bundle.
 * @example
 *
 * ```ts
 * const { Paragraph } = await loadCKCdnResourcesPack(
 * 	createCKCdnBaseBundlePack( {
 * 		version: '44.0.0',
 * 		translations: [ 'es', 'de' ]
 * 	} )
 * );
 * ```
 */
export declare function createCKCdnBaseBundlePack({ version, translations, createCustomCdnUrl }: CKCdnBaseBundlePackConfig): CKCdnResourcesAdvancedPack<Window['CKEDITOR']>;
/**
 * Configuration of the base CKEditor bundle pack.
 */
export type CKCdnBaseBundlePackConfig = {
    /**
     * The version of  the base CKEditor bundle.
     */
    version: CKCdnVersion;
    /**
     * The list of translations to load.
     */
    translations?: Array<string>;
    /**
     * The function that creates custom CDN URLs.
     */
    createCustomCdnUrl?: CKCdnUrlCreator;
};
