/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * @module basic-styles/bold
 */
import { Plugin } from 'ckeditor5/src/core.js';
import BoldEditing from './bold/boldediting.js';
import BoldUI from './bold/boldui.js';
/**
 * The bold feature.
 *
 * For a detailed overview check the {@glink features/basic-styles Basic styles feature} guide
 * and the {@glink api/basic-styles package page}.
 *
 * This is a "glue" plugin which loads the {@link module:basic-styles/bold/boldediting~BoldEditing bold editing feature}
 * and {@link module:basic-styles/bold/boldui~BoldUI bold UI feature}.
 */
export default class Bold extends Plugin {
    /**
     * @inheritDoc
     */
    static get requires(): readonly [typeof BoldEditing, typeof BoldUI];
    /**
     * @inheritDoc
     */
    static get pluginName(): "Bold";
    /**
     * @inheritDoc
     */
    static get isOfficialPlugin(): true;
}
