import { NextResponse } from "next/server";
import type { NextRequest } from "next/server";

export function middleware(req: NextRequest) {
    const res = NextResponse.next();
    res.cookies.set("pathname", req.nextUrl.pathname); // ✅ Store pathname in cookies
    return res;
}

// Apply middleware to all routes
export const config = {
    matcher: "/:path*",
};
