import { SessionOptions } from "iron-session"

export interface SessionData {
    id?: string,
    name?: string,
    email?: string,
    role?: string,
    islogged?: boolean
}
export const defaultSession: SessionData = {
    islogged: false
}
export const sessionOptions: SessionOptions = {
    password: process.env.SECRET!,
    cookieName: "BQToken",
    cookieOptions: {
        httpOnly: true,
        secure: process.env.NODE_ENV === "production",
        maxAge: 24 * 60 * 60
    }
}