import { Clock, Film, GraduationCap, Users } from 'lucide-react'
import React from 'react'

export const Details = () => {
    return (
        <div className='bg-[#066ccc]'>
            <div className='container mx-auto p-16'>
                <div className='grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-10 md:gap-5'>
                    <div className='flex items-center gap-4'>
                        <div className='w-16 h-16 rounded-full bg-white flex items-center justify-center'>
                            <Film className='w-8 h-8 text-[#066ccc]' />
                        </div>
                        <div className='flex flex-col gap-4 text-white'>
                            <h2 className='text-2xl font-bold'>1000+ Topics</h2>
                            <p>Enjoy a variety of fresh topics</p>
                        </div>
                    </div>
                    <div className='flex items-center gap-4'>
                        <div className='w-16 h-16 rounded-full bg-white flex items-center justify-center'>
                            <Users className='w-8 h-8 text-[#066ccc]' />
                        </div>
                        <div className='flex flex-col gap-4 text-white'>
                            <h2 className='text-2xl font-bold'>Expert Instructors</h2>
                            <p>Find the right instructor for you</p>
                        </div>
                    </div>
                    <div className='flex items-center gap-4'>
                        <div className='w-16 h-16 rounded-full bg-white flex items-center justify-center'>
                            <Clock className='w-8 h-8 text-[#066ccc]' />
                        </div>
                        <div className='flex flex-col gap-4 text-white'>
                            <h2 className='text-2xl font-bold'>Life time access</h2>
                            <p>Learn on your schedule</p>
                        </div>
                    </div>
                    <div className='flex items-center gap-4'>
                        <div className='w-16 h-16 rounded-full bg-white flex items-center justify-center'>
                            <GraduationCap className='w-8 h-8 text-[#066ccc]' />
                        </div>
                        <div className='flex flex-col gap-4 text-white'>
                            <h2 className='text-2xl font-bold'>Get Certificate</h2>
                            <p>When Courses Complete Categories</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}
