import { CheckCheck, CheckCircle, Lightbulb, NotebookPen, Quote, School, Trophy } from "lucide-react";
import { motion } from "framer-motion";
import Image from "next/image";

const features = [
    {
        title: "Expert Instructors",
        description: "Learn from industry professionals with years of experience in AI and web development.",
    },
    {
        title: "Hands-on Learning",
        description: "Engage in practical projects to apply your knowledge and build real-world applications.",
    },
    {
        title: "Career Support",
        description: "Get guidance, mentorship, and networking opportunities to accelerate your career.",
    },
    {
        title: "Flexible Learning",
        description: "Access courses anytime, anywhere with our user-friendly platform and structured curriculum.",
    },
];

const counters = [
    { number: "10K+", label: "Students Trained" },
    { number: "500+", label: "Live Projects" },
    { number: "100+", label: "Expert Instructors" },
    { number: "95%", label: "Success Rate" },
];

export default function WhyChooseUs() {
    return (
        <div className="bg-[#f2f9ff] p-20">
            <div content="container mx-auto">
                <div className="grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div className="relative flex items-center justify-end">
                        <Image src="https://images.unsplash.com/photo-1614741118887-7a4ee193a5fa?q=80&w=3387&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D"
                            alt="Why Choose us" width={1200} height={1200} className="md:w-[600px] h-[400px] md:h-[800px] rounded-xl" priority />
                        <div className="w-24 h-24 rounded-full bg-green-500 flex items-center justify-center absolute top-10 -left-10 md:top-20 md:left-25 animate-bounce duration-[1s,15s] transition-all">
                            <Trophy className="text-white w-12 h-12" />
                        </div>
                        <div className="w-64 rounded-xl bg-white p-2 flex items-center gap-2 absolute bottom-10 md:bottom-30 -right-10 animate-bounce">
                            <div className="w-16 h-16 rounded-full flex items-center justify-center bg-purple-500">
                                <Quote />
                            </div>
                            <div className="flex flex-col">
                                <h3 className="text-xl font-bold">20 % OFF</h3>
                                <p className="text-md">For All Courses</p>
                            </div>
                        </div>
                    </div>
                    <div className="p-5 md:p-14 space-y-3">
                        <div className="flex items-center gap-2 text-[#066ccc] text-xl font-bold">
                            <CheckCheck /> Why Choose Us
                        </div>
                        <h1 className="text-3xl md:text-5xl font-bold">Over 16 Years in Distant learning for Skill Development</h1>
                        <p className="text-md md:text-xl text-gray-600">We are passionate about transforming lives
                            through education. Founded with a vision to make learning accessible to all</p>

                        <div className="flex flex-col items-center">
                            <div className="grid grid-cols-1 md:grid-cols-2 gap-5">
                                <div className="flex items-center justify-center gap-4">
                                    <div className="w-24 h-16 md:w-24 md:h-18 rounded-full bg-white flex items-center justify-center text-[#066ccc]">
                                        <NotebookPen />
                                    </div>
                                    <div className="flex flex-col">
                                        <h2 className=" text-xl md:text-3xl font-bold">Academic Excellence</h2>
                                        <p>Through our curated courses, interactive content</p>
                                    </div>
                                </div>
                                <div className="flex items-center justify-center gap-4">
                                    <div className="w-24 h-16 md:w-24 md:h-18 rounded-full bg-white flex items-center justify-center text-[#066ccc]">
                                        <School />
                                    </div>
                                    <div className="flex flex-col ">
                                        <h2 className="text-xl md:text-3xl font-bold">Course Offerings</h2>
                                        <p>Through our curated courses, interactive content</p>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div className="flex flex-col items-center">
                            <div className="grid grid-cols-1 md:grid-cols-2 gap-5">
                                <div className="flex items-center justify-center gap-4">
                                    <div className="w-24 h-16 md:w-24 md:h-18 rounded-full bg-white flex items-center justify-center text-[#066ccc]">
                                        <NotebookPen />
                                    </div>
                                    <div className="flex flex-col ">
                                        <h2 className="text-xl md:text-3xl font-bold">Innovative Learning</h2>
                                        <p>Through our curated courses, interactive content</p>
                                    </div>
                                </div>
                                <div className="flex items-center justify-center gap-4">
                                    <div className="w-24 h-16 md:w-24 md:h-18 rounded-full bg-white flex items-center justify-center text-[#066ccc]">
                                        <School />
                                    </div>
                                    <div className="flex flex-col ">
                                        <h2 className="text-xl md:text-3xl font-bold">Sustainability Initiative</h2>
                                        <p>Be part of a university that cares about the planet.</p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>

        </div>
    );
}
