'use client'
import { BookOpenText, Quote, Star } from 'lucide-react'
import React, { useEffect, useState } from 'react'
import { Card, CardContent } from '../ui/card'
import Image from 'next/image'
import Carousel from 'react-multi-carousel'
import { getAllTestimonials } from '@/app/api/testimonials'

const Testimonials = () => {
    const responsive = {
        superLargeDesktop: { breakpoint: { max: 4000, min: 3000 }, items: 3 },
        desktop: { breakpoint: { max: 3000, min: 1024 }, items: 2 },
        tablet: { breakpoint: { max: 1024, min: 464 }, items: 1 },
        mobile: { breakpoint: { max: 464, min: 0 }, items: 1 }
    };
    const [testimonials, setTestimonials] = useState<any[]>([]);
    const [loading, setLoading] = useState(true);
    const [error, setError] = useState("");

    useEffect(() => {
        const fetchCompanies = async () => {
            const { testimonials, error } = await getAllTestimonials()
            if (error) {
                setError(error)
            } else {
                setTestimonials(testimonials as [])
                setLoading(false)
            }


        }
        fetchCompanies();
    }, [])

    return (
        <div className="container mx-auto py-16">
            <div className="py-16 max-w-xl md:max-w-2xl mx-auto flex flex-col items-center gap-4">
                <h1 className="flex items-center gap-3 text-[#066ccc] text-2xl font-bold">
                    <BookOpenText /> Testimonials
                </h1>
                <h2 className="text-4xl md:text-5xl font-bold text-center">
                    What Our Students Say
                </h2>
                <p className="text-center text-md md:text-lg text-gray-600">
                    Our platform is built on the principles of innovation, quality, and inclusivity, aiming to provide a seamless learning experience.
                </p>
            </div>
            <div className='p-6'>
                <Carousel responsive={responsive} >
                    {testimonials.map((testimonial, index) => (
                        <Card key={index} className="bg-[#f2f9ff] p-6 mr-5">
                            <CardContent className="relative space-y-4">
                                <div className="flex items-center gap-1">
                                    {Array.from({ length: 5 }).map((_, i) => (
                                        <Star key={i} className="text-orange-400" />
                                    ))}
                                </div>
                                <p className="text-xl text-gray-700">{testimonial.review}</p>
                                <hr />
                                <div className="flex items-center justify-between">
                                    <div className="flex items-center gap-4">
                                        <Image
                                            src={testimonial.avatar || `https://ui-avatars.com/api/?name=${testimonial.name.trim()}`}
                                            alt={testimonial.name}
                                            width={64}
                                            height={64}
                                            className="bg-white w-16 h-16 rounded-full"
                                        />
                                        <div className="flex flex-col">
                                            <h1 className="font-bold">{testimonial.name}</h1>
                                            <p>{testimonial.role}</p>
                                        </div>
                                    </div>
                                    <Quote />
                                </div>
                            </CardContent>
                        </Card>
                    ))}
                </Carousel>
            </div>
        </div>
    );
};

export default Testimonials;
