import { ArrowBigRight, ArrowRight, BookMarked } from 'lucide-react'
import React from 'react'
import { Button } from '../ui/button'
import Image from 'next/image'
import banner from '@/public/banner.png'
import Link from 'next/link'

const HeroSection = () => {
    return (
        <div className='home-hero-bg'>
            <div className=''>
                <div className='container mx-auto'>
                    <div className='grid grid-cols-1 md:grid-cols-2 p-6 md:p-16'>
                        <div className='space-y-6 p-6 md:p-16'>
                            <div className='flex items-center text-[#066ccb]'>
                                <BookMarked className='mr-4' />
                                <h3 className='text-lg md:text-2xl font-bold'>Elevate Your Learning</h3>

                            </div>
                            <h1 className='text-5xl md:text-7xl font-bold'>Learn, <span className='text-orange-600'>Grow</span>, <span className='text-green-600'>Achieve</span> and Succeed</h1>
                            <p className='text-md text-gray-600 md:text-base'>Unlock your full potential with expert-led courses designed to help
                                you learn, grow, achieve, and succeed. Whether you're mastering new
                                skills, advancing your career, or exploring cutting-edge technologies,
                                we provide the tools and knowledge to turn your ambitions into reality.
                                Your journey to success starts here!
                            </p>
                            <div className='flex items-center gap-4'>
                                <Link href="/courses">
                                    <Button className='h-14 md:h-16 bg-blue-500 hover:bg-blue-600 rounded-full '>
                                        <div className='flex items-center text-lg gap-3'>
                                            Browse Courses
                                            <ArrowRight className='w-14 h-14' />
                                        </div>
                                    </Button>
                                </Link>
                                <Link href="/about-us">
                                    <Button variant='outline' className='h-14 md:h-16 rounded-full '>
                                        <div className='flex items-center text-lg gap-3'>
                                            About Us
                                            <ArrowRight className='w-14 h-14' />
                                        </div>
                                    </Button>
                                </Link>
                            </div>

                        </div>

                        <div className='flex items-center justify-center  overflow-hidden'>
                            <Image src={banner} alt="Binary Qubit" width={400} height={600} className=' border rounded-xl' priority />
                        </div>
                    </div>
                </div>
            </div>

        </div>
    )
}

export default HeroSection