import { ArrowRight, BookOpenText } from 'lucide-react'
import Link from 'next/link'
import React from 'react'
import { Card, CardContent } from '../ui/card'

const GettingSkilled = () => {
    return (
        <div>
            <div className='contaier mx-auto p-16'>
                <div className='grid grid-cols-1 md:grid-cols-2 gap-10'>
                    <h1 className='text-3xl md:text-5xl font-bold pl-20'>Build better growth skills, faster. Ignite Your Learning Journey</h1>
                    <div className='flex flex-col p-10 space-y-10'>

                        <h2 className='text-xl'>Explore new skills, deepen existing passions, and get lost in creativity. What you find just might...</h2>
                        <Link href="">
                            <div className='flex items-center text-blue-500'>
                                <span className='text-lg'> Read More</span> <ArrowRight className='w-4 h-4' />
                            </div>
                        </Link>
                    </div>
                </div>

            </div>

            <div className='bg-[#f2f9ff] py-10'>
                <div className='max-w-6xl mx-auto'>
                    <div className='grid grid-cols-1 md:grid-cols-3 gap-5 p-5 '>
                        <Card className='hover:bg-blue-500 hover:text-white'>
                            <CardContent>
                                <div className='flex flex-col items-center space-y-6'>
                                    <div className='w-36 h-36 rounded-full bg-[#f2f9ff] hover:bg-white flex items-center justify-center'>
                                        <BookOpenText className='w-20 h-20 text-blue-500' />
                                    </div>
                                    <h3 className='text-2xl font-bold'>Learn the latest skills</h3>
                                    <p className='text-center'>Quality education shouldn't break the bank. We offer competitive pricing and payment</p>
                                    <div className='flex items-center justify-center'>
                                        <hr className='w-20' />
                                    </div>
                                </div>

                            </CardContent>
                        </Card>
                        <Card className='hover:bg-blue-500 hover:text-white'>
                            <CardContent>
                                <div className='flex flex-col items-center space-y-6'>
                                    <div className='w-36 h-36 rounded-full bg-[#f2f9ff] hover:bg-white flex items-center justify-center'>
                                        <BookOpenText className='w-20 h-20 text-blue-500' />
                                    </div>
                                    <h3 className='text-2xl font-bold'>Get ready for a career</h3>
                                    <p className='text-center'>Engage in dynamic and interactive learning experiences. Our courses are</p>
                                    <div className='flex items-center justify-center'>
                                        <hr className='w-20' />
                                    </div>
                                </div>

                            </CardContent>
                        </Card>

                        <Card className='hover:bg-blue-500 hover:text-white'>
                            <CardContent>
                                <div className='flex flex-col items-center space-y-6'>
                                    <div className='w-36 h-36 rounded-full bg-[#f2f9ff] hover:bg-white flex items-center justify-center'>
                                        <BookOpenText className='w-20 h-20 text-blue-500' />
                                    </div>
                                    <h3 className='text-2xl font-bold'>Earn a Certificate</h3>
                                    <p className='text-center'>Join a vibrant and supportive learning community. Connect with fellow</p>
                                    <div className='flex items-center justify-center'>
                                        <hr className='w-20 text-gray-900' />
                                    </div>
                                </div>

                            </CardContent>
                        </Card>
                    </div>
                </div>
            </div>

        </div>
    )
}

export default GettingSkilled