import { Facebook, Twitter, Linkedin } from "lucide-react";

export default function Footer() {
    return (
        <footer className="bg-gray-900 text-white py-10">
            <div className="max-w-7xl mx-auto px-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">

                {/* Company Section */}
                <div>
                    <h2 className="text-xl font-semibold mb-4">BinaryQubit</h2>
                    <p className="text-gray-400">
                        Providing top-tier coding courses in AI, Web Development, and Data Science.
                    </p>
                </div>

                {/* Courses Section */}
                <div>
                    <h2 className="text-xl font-semibold mb-4">Courses</h2>
                    <ul className="space-y-2">
                        <li><a href="#" className="text-gray-400 hover:text-white">Web Development</a></li>
                        <li><a href="#" className="text-gray-400 hover:text-white">Machine Learning</a></li>
                        <li><a href="#" className="text-gray-400 hover:text-white">Data Science</a></li>
                        <li><a href="#" className="text-gray-400 hover:text-white">Algorithmic Trading</a></li>
                    </ul>
                </div>

                {/* Resources Section */}
                <div>
                    <h2 className="text-xl font-semibold mb-4">Resources</h2>
                    <ul className="space-y-2">
                        <li><a href="#" className="text-gray-400 hover:text-white">Blog</a></li>
                        <li><a href="#" className="text-gray-400 hover:text-white">Documentation</a></li>
                        <li><a href="#" className="text-gray-400 hover:text-white">Community</a></li>
                        <li><a href="#" className="text-gray-400 hover:text-white">Support</a></li>
                    </ul>
                </div>

                {/* Contact Section */}
                <div>
                    <h2 className="text-xl font-semibold mb-4">Contact</h2>
                    <p className="text-gray-400">Email: support@binaryqubit.com</p>
                    <p className="text-gray-400">Phone: +1 (123) 456-7890</p>
                    <div className="flex space-x-4 mt-4">
                        <a href="#" className="text-gray-400 hover:text-white">
                            <Facebook size={20} />
                        </a>
                        <a href="#" className="text-gray-400 hover:text-white">
                            <Twitter size={20} />
                        </a>
                        <a href="#" className="text-gray-400 hover:text-white">
                            <Linkedin size={20} />
                        </a>
                    </div>
                </div>
            </div>

            <div className="text-center text-gray-500 text-sm mt-8 border-t border-gray-700 pt-4">
                © {new Date().getFullYear()} BinaryQubit. All rights reserved.
            </div>
        </footer>
    );
}
