'use client'
import { motion } from 'framer-motion'
import React from 'react'
import { Button } from '../ui/button'
import { ArrowRight } from 'lucide-react'

const CourseDetailsHero = ({ title, description, banner }: { title: string, description: string, banner: string }) => {
    return (
        <div className="relative bg-[#1a1d29] text-white overflow-hidden">
            <div className="max-w-7xl mx-auto px-6 lg:px-8">
                <div className="grid grid-cols-1 md:grid-cols-2 items-center min-h-[450px]">
                    <div className="max-w-2xl space-y-6">
                        <motion.h2
                            className="text-5xl font-bold tracking-tight sm:text-6xl"
                            initial={{ opacity: 0, y: -20 }}
                            animate={{ opacity: 1, y: 0 }}
                            transition={{ duration: 0.6 }}
                        >
                            {title}
                        </motion.h2>
                        <motion.p
                            className="text-lg text-gray-300"
                            initial={{ opacity: 0 }}
                            animate={{ opacity: 1 }}
                            transition={{ duration: 0.8 }}
                        >
                            {description}
                        </motion.p>

                    </div>
                    <div className="flex justify-center p-6">
                        <motion.img
                            src={banner}
                            alt={title}
                            className="w-full max-w-lg rounded-lg shadow-2xl"
                            initial={{ opacity: 0, scale: 0.9 }}
                            animate={{ opacity: 1, scale: 1 }}
                            transition={{ duration: 0.8 }}
                        />
                    </div>
                </div>
            </div>
        </div>
    )
}

export default CourseDetailsHero