import { BugOff, DatabaseZap, FileUser, GlobeLock } from 'lucide-react'
import Image from 'next/image'
import React from 'react'
import certi from '@/public/certi.png'

const certificates = [
    {
        icon: <DatabaseZap />,
        title: "Industry-Recognized Certification",
        content: "Gain a certificate that validates your expertise and enhances your career opportunities."
    },
    {
        icon: <BugOff />,
        title: "Hands-On Skill Development",
        content: "Master real-world skills through practical projects and industry-relevant coursework."
    },
    {
        icon: <FileUser />,
        title: "Boost Your Resume & Credibility",
        content: "Showcase your achievements and stand out in the competitive job market."
    },
    {
        icon: <GlobeLock />,
        title: "Global Career Opportunities",
        content: "Leverage your certification to unlock job prospects worldwide in top tech industries."
    },

]
const Certificate = () => {
    return (
        <div className='py-16'>
            <div className='max-w-3xl mx-auto space-y-6'>
                <h1 className='text-3xl md:text-4xl font-bold text-center'>Skills Certificate from the Binary Qubit</h1>
                <p className='text-center'>Our platform is built on the principles of innovation, quality, and inclusivity, aiming to provide a seamless learning education</p>
            </div>
            <div className='container mx-auto p-20'>
                <div className='grid grid-cols-1 md:grid-cols-2 gap-5'>
                    <div className='flex flex-col space-y-5 p-10'>


                        {certificates.map((c, i) => (
                            <div key={i} className='flex flex-col space-y-6'>
                                <div className='flex items-center gap-5'>
                                    <div className='flex items-center justify-center w-16 h-16 rounded-full bg-[#f2f9ff] text-[#066ccc]'>
                                        {c.icon}
                                    </div>
                                    <h3 className='text-xl font-bold'>{c.title}</h3>
                                </div>
                                <p>{c.content}</p>

                                <hr />
                            </div>
                        ))}
                    </div>
                    <div className='flex items-center justify-center'>
                        <Image src={certi} alt="Binary Qubit Certification" width={1200} height={600} className='w-full ' priority />
                    </div>
                </div>
            </div>
        </div>
    )
}

export default Certificate