'use client'
import { Book, Globe, Code, BarChart, Brain, Database, FlaskConical, ListCheck, Loader } from 'lucide-react'
import React, { useEffect, useState } from 'react'
import { Card, CardContent } from '../ui/card'
import { getAllCategories } from '@/app/api/categories'
import * as LucideIcons from 'lucide-react';

const CategorySection = () => {
    const [categories, setCategories] = useState<any[]>([]);
    const [loading, setLoading] = useState<boolean>(true);
    const [error, setError] = useState<string>("");

    useEffect(() => {
        const fetchAllCategory = async () => {
            const { categories, error } = await getAllCategories();
            if (error) {
                setError(error);
            } else {
                setCategories(categories || []);
                setLoading(false);
            }
        };
        fetchAllCategory();
    }, []);

    return (
        <div className="pb-16">
            <div className="container mx-auto">
                <div className="py-16 max-w-xl md:max-w-2xl mx-auto flex flex-col items-center gap-4">
                    <h1 className="flex items-center gap-3 text-[#066ccc] text-2xl font-bold">
                        <ListCheck /> Categories
                    </h1>
                    <h2 className="text-4xl md:text-5xl font-bold text-center">
                        Elevate Your Learning Experience
                    </h2>
                    <p className="text-center text-md md:text-lg text-gray-600">
                        Our platform is built on the principles of innovation, quality, and inclusivity, aiming to provide a seamless learning experience.
                    </p>
                </div>

                <div className="flex items-center justify-center">
                    <div className="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-6">
                        {loading ? (
                            <Loader className="animate-spin" />
                        ) : (
                            categories.map((category: any, index) => {
                                const IconComponent = (LucideIcons as any)[category.icon];
                                return (
                                    <Card key={index} className="transition-transform transform hover:scale-105">
                                        <CardContent className="px-4 flex items-center gap-4">
                                            {IconComponent ? (
                                                <IconComponent className="h-6 w-6 text-[#066ccc]" />
                                            ) : (
                                                <p>Invalid Icon</p>
                                            )}
                                            <span className="text-xl font-medium">{category.name}</span>
                                        </CardContent>
                                    </Card>
                                );
                            })
                        )}
                    </div>
                </div>
            </div>
        </div>
    );
}

export default CategorySection;
