'use client'
import { ArrowRight, BookOpenText, ChartNoAxesCombined, Clock3, IndianRupee, Loader, Star, Video } from 'lucide-react'
import React, { useEffect, useState } from 'react'
import { Card, CardContent } from '../ui/card'
import Image from 'next/image'
import course from '@/public/upload/banner/course.jpg'
import { getCourses } from '@/app/api/courses'
import Link from 'next/link'
import { Button } from '../ui/button'

const Courses = () => {
    const [courses, setCourses] = useState<any[]>([]);
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        const fetchCourses = async () => {
            const { courses, error } = await getCourses()
            if (!error) {
                setCourses(courses?.slice(0, 6) || [])
            }
        }
        fetchCourses()
        setLoading(false)
    }, [])
    return (
        <div className='bg-[#f2f9ff]'>
            <div className='container mx-auto p-16'>
                <div className="py-16 max-w-xl md:max-w-2xl mx-auto flex flex-col items-center gap-4">
                    <h1 className="flex items-center gap-3 text-[#066ccc] text-2xl font-bold">
                        <BookOpenText /> Courses
                    </h1>
                    <h2 className="text-4xl md:text-5xl font-bold text-center">
                        Pick A Course To Get Started
                    </h2>
                    <p className="text-center  text-md md:text-lg text-gray-600">
                        Our platform is built on the principles of innovation, quality, and inclusivity, aiming to provide a seamless learning experience.
                    </p>
                </div>


                <div className='grid  grid-cols-1 md:grid-cols-3 gap-5'>
                    {
                        loading ?
                            <div className='w-full h-full flex items-center justify-center'><Loader className="h-8 w-8 animate-spin" /> Loading...</div>
                            :
                            courses.map((course) => (
                                <Link href={`/courses/${course.id}`} key={course.id}>

                                    <Card>
                                        <CardContent className='relative'>
                                            <img src={course.banner} alt="Coures Name" className='w-full h-[300px] rounded-xl' />
                                            <div className='mt-5'>
                                                <h1 className='text-3xl font-bold'>{course.name}</h1>
                                                <div className='flex items-center justify-between mt-5 mb-6'>
                                                    <div className='flex items-center gap-2  text-lg text-gray-700'><Video /> 20 Lessons</div>
                                                    <div className='flex items-center gap-2 text-lg text-gray-700'><ChartNoAxesCombined /> {course.level}</div>
                                                </div>
                                                <div className='flex items-center justify-between mb-6'>
                                                    <div className='flex items-center gap-2 text-lg text-gray-700'><Star className='text-orange-600 ' /> 4.7 (6K)</div>

                                                </div>
                                                <hr />
                                                <div className='flex items-center justify-between mt-5 mb-6'>
                                                    <div className='flex items-center   text-2xl font-bold text-orange-500'><IndianRupee className='w-6 h-6' /> {course.price}</div>
                                                    <div className='flex items-center gap-2 text-lg text-gray-700'> Enroll Now <ArrowRight /> </div>
                                                </div>
                                            </div>
                                            <div className='w-36 h-12 bg-[#066ccc] rounded-full absolute top-5 left-10 p-2'>
                                                <div className='flex items-center justify-center gap-2 text-lg text-white'><Clock3 /> {course.duration} Months</div>
                                            </div>

                                        </CardContent>
                                    </Card>
                                </Link>
                            ))}


                </div>

                <div className='flex items-center justify-center  gap-4 mt-4'>
                    <Link href="/courses">
                        <Button className='h-14 md:h-16 bg-blue-500 hover:bg-blue-600 rounded-full '>
                            <div className='flex items-center text-lg gap-3'>
                                See More
                                <ArrowRight className='w-14 h-14' />
                            </div>
                        </Button>
                    </Link>
                </div>

            </div>
        </div>
    )
}

export default Courses