import React from 'react'

import {
    Breadcrumb,
    BreadcrumbItem,
    BreadcrumbLink,
    BreadcrumbList,
    BreadcrumbPage,
    BreadcrumbSeparator,
} from "@/components/ui/breadcrumb"

const HeroSection = ({ title, link }: { title: string, link: string }) => {
    return (
        <div className='h-84 hero-bg bg-cover'>
            <div className='contaier mx-auto p-28 flex flex-col items-center justify-center'>
                <h1 className='text-4xl font-bold text-center'>{title}</h1>
                <Breadcrumb>
                    <BreadcrumbList>
                        <BreadcrumbItem>
                            <BreadcrumbLink className=' hover:text-gray-700' href="/">Home</BreadcrumbLink>
                        </BreadcrumbItem>
                        <BreadcrumbSeparator />

                        <BreadcrumbItem>
                            <BreadcrumbLink className=' hover:text-gray-700' href="#">{link}</BreadcrumbLink>
                        </BreadcrumbItem>
                    </BreadcrumbList>
                </Breadcrumb>

            </div>
        </div>
    )
}

export default HeroSection