import Link from 'next/link'
import React from 'react'
import { Button } from '../ui/button'
import { Menu } from 'lucide-react'
import { Sheet, SheetTrigger, SheetContent, SheetTitle } from '../ui/sheet'
import Image from 'next/image'

const GuestHeader = () => {
    return (
        <header className=" bg-[#f3f8fc]  w-full z-50 shadow ">
            <div className="container mx-auto px-4 py-2 sm:px-6 lg:px-8">
                <div className="flex h-16 items-center justify-between">
                    <div className="flex items-center">
                        <Link href="/" className="text-2xl font-bold text-primary">
                            <Image src="/upload/logo/Binary.png" alt='Binary Qubit logo' width={200} height={200} priority />
                        </Link>
                    </div>

                    {/* Desktop Navigation */}
                    <nav className="hidden md:flex items-center space-x-8 font-medium ">
                        <Link href="/courses" className="text-gray-600 hover:text-primary">
                            Courses
                        </Link>
                        <Link href="/gallery" className="text-gray-600 hover:text-primary">
                            Gallery
                        </Link>
                        <Link href="/clients" className="text-gray-600 hover:text-primary">
                            Collabrations
                        </Link>
                        <Link href="/about-us" className="text-gray-600 hover:text-primary">
                            About
                        </Link>
                        <Link href="/contact-us" className="text-gray-600 hover:text-primary">
                            Contact
                        </Link>

                    </nav>

                    {/* Mobile Navigation */}
                    <div className="md:hidden">
                        <Sheet>
                            <SheetTrigger asChild>
                                <Button variant="ghost" size="icon">
                                    <Menu className="h-6 w-6" />
                                </Button>
                            </SheetTrigger>
                            <SheetContent className='p-5'>
                                <SheetTitle></SheetTitle>
                                <nav className="flex flex-col space-y-4">
                                    <Link href="/courses" className="text-gray-600 hover:text-primary">
                                        Courses
                                    </Link>
                                    <Link href="/Gallrey" className="text-gray-600 hover:text-primary">
                                        Gallery
                                    </Link>
                                    <Link href="/clients" className="text-gray-600 hover:text-primary">
                                        Our clients
                                    </Link>
                                    <Link href="/about" className="text-gray-600 hover:text-primary">
                                        About
                                    </Link>
                                    <Link href="/contact" className="text-gray-600 hover:text-primary">
                                        Contact
                                    </Link>

                                </nav>
                            </SheetContent>
                        </Sheet>
                    </div>
                </div>
            </div>
        </header>
    )
}

export default GuestHeader