"use client"

import Link from "next/link"
import { usePathname } from "next/navigation"
import { cn } from "@/lib/utils"
import {
    BarChart,
    BookOpen,
    GraduationCap,
    LayoutDashboard,
    Settings,
    Users,
    FileText,
    Image,
    Mail,
    Building2,
    Award,
    HandHelping,
    Handshake,
    UserCogIcon,
    FolderOpenIcon,
} from "lucide-react"

const navigation = [
    { name: "Dashboard", href: "/admin", icon: LayoutDashboard },
    { name: "Students", href: "/admin/students", icon: GraduationCap },
    { name: "Categories", href: "/admin/categories", icon: FolderOpenIcon },
    { name: "Courses", href: "/admin/courses", icon: BookOpen },
    { name: "Companies", href: "/admin/companies", icon: Building2 },
    { name: "Testimonials", href: "/admin/testimonials", icon: Award },
    { name: "Partners", href: "/admin/partners", icon: Handshake },
    { name: "Clients", href: "/admin/clients", icon: Users },
    { name: "Gallery", href: "/admin/galleries", icon: Image },

    { name: "Instructors", href: "/admin/instructors", icon: Users },
    { name: "Analytics", href: "/admin/analytics", icon: BarChart },


    { name: "Settings", href: "/admin/settings", icon: Settings },
]

export default function AdminSidebar() {
    const pathname = usePathname()

    return (
        <div className="w-64  bg-white min-h-screen border-r flex flex-col">
            <div className="p-6">
                <Link href="/admin" className="flex items-center space-x-2">
                    <GraduationCap className="h-6 w-6 text-primary" />
                    <span className="text-xl font-bold">Admin Panel</span>
                </Link>
            </div>
            <nav className="flex-1 px-4 space-y-1">
                {navigation.map((item) => {
                    const isActive = pathname === item.href
                    return (
                        <Link
                            key={item.name}
                            href={item.href}
                            className={cn(
                                "flex items-center space-x-2 px-3 py-2 rounded-md text-sm font-medium transition-colors",
                                isActive ? "bg-primary text-primary-foreground" : "text-muted-foreground hover:bg-muted",
                            )}
                        >
                            <item.icon className="h-5 w-5" />
                            <span>{item.name}</span>
                        </Link>
                    )
                })}
            </nav>
        </div>
    )
}

