"use client"

import { category } from "@/app/admin/categories/page"
import { Button } from "@/components/ui/button"
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from "@/components/ui/dropdown-menu"
import { ColumnDef } from "@tanstack/react-table"
import { Edit, MoreHorizontal, MoreVertical, Trash } from "lucide-react"
import * as LucideIcons from 'lucide-react'
// This type is used to define the shape of our data.
// You can use a Zod schema here if you want.

type Category = {
    id: string
    name: string
    icon: string
    _count: any
}
export const createColumns = (
    handleEdit: (data: category) => void,
    handleDelete: (data: category) => void
): ColumnDef<Category>[] => [
        {
            accessorKey: "name",
            header: "Name",
        },
        {
            accessorKey: "icon",
            header: "Icon",
            cell: ({ row }) => {

                const IconComponent = (LucideIcons as any)[row.original.icon];
                return IconComponent ? <IconComponent className="h-6 w-6 text-gray-700" /> : <p>Invalid Icon</p>
            }
        },

        {
            accessorKey: "_count",
            header: "Total Courses",
            cell: ({ row }) => (
                <p>
                    {row.original._count.courses}
                </p>
            )
        },

        {
            header: "Actions",
            id: "actions",
            cell: ({ row }) => (

                <DropdownMenu>
                    <DropdownMenuTrigger asChild>
                        <Button variant="ghost" className="h-8 w-8 p-0">
                            <MoreVertical className="h-4 w-4" />
                        </Button>
                    </DropdownMenuTrigger>
                    <DropdownMenuContent align="end">
                        <DropdownMenuItem onClick={() => handleEdit(row.original)}>
                            <Edit className="h-4 w-4 mr-2" /> Edit
                        </DropdownMenuItem>
                        <DropdownMenuItem onClick={() => handleDelete(row.original)} className="text-red-600">
                            <Trash className="h-4 w-4 mr-2" /> Delete
                        </DropdownMenuItem>
                    </DropdownMenuContent>
                </DropdownMenu>
            ),
        }
    ]


