"use client"

import { createTestimonials } from '@/app/api/testimonials'
import { Button } from '@/components/ui/button'
import { Dialog, DialogContent, DialogDescription, DialogHeader, DialogTitle } from '@/components/ui/dialog'
import { Form, FormControl, FormField, FormItem, FormLabel, FormMessage } from '@/components/ui/form'
import { Input } from '@/components/ui/input'
import { Textarea } from '@/components/ui/textarea'
import { zodResolver } from '@hookform/resolvers/zod'


import React from 'react'
import { useForm } from 'react-hook-form'


import { z } from "zod"
import { testimonials } from './columns'

const formSchema = z.object({
    name: z.string().min(2).max(50),

    designation: z.string().min(2, { message: "Designation is required" }),
    message: z.string().min(20, { message: "Message should be of 20 Characters" }),
    rating: z.string()
})

const TestimonialModel = ({ open, onOpenChange, changeState }: { open: boolean, onOpenChange: (open: boolean) => void, changeState: React.Dispatch<React.SetStateAction<testimonials[]>> }) => {
    const form = useForm<z.infer<typeof formSchema>>({
        resolver: zodResolver(formSchema),
        defaultValues: {
            name: "",
            designation: "",
            message: "",
            rating: ""
        }
    })

    const onSubmit = async (values: z.infer<typeof formSchema>) => {
        const { testimonials, error } = await createTestimonials(values)
        if (!error && testimonials) {
            onOpenChange(false)
            changeState((prev) => [testimonials, ...prev])
        } else {
            console.log(error)
        }
    }
    return (
        <div>
            <Dialog open={open} onOpenChange={onOpenChange}>
                <DialogContent>
                    <DialogHeader>
                        <DialogTitle>Add New Testimonial</DialogTitle>
                        <DialogDescription></DialogDescription>
                    </DialogHeader>
                    <Form {...form}>
                        <form onSubmit={form.handleSubmit(onSubmit)} className='space-y-6'>
                            <FormField
                                control={form.control}
                                name="name"
                                render={({ field }) => (
                                    <FormItem>
                                        <FormLabel>Name</FormLabel>
                                        <FormControl>
                                            <Input type='text' placeholder='e.g.  Microsoft' {...field} />
                                        </FormControl>
                                        <FormMessage />
                                    </FormItem>
                                )}
                            />

                            <FormField
                                control={form.control}
                                name="designation"
                                render={({ field }) => (
                                    <FormItem>
                                        <FormLabel>Designation</FormLabel>
                                        <FormControl>
                                            <Input type='text' placeholder='e.g.  Developer at BinaryQubit' {...field} />
                                        </FormControl>
                                        <FormMessage />
                                    </FormItem>
                                )}
                            />

                            <FormField
                                control={form.control}
                                name="message"
                                render={({ field }) => (
                                    <FormItem>
                                        <FormLabel>Message</FormLabel>
                                        <FormControl>
                                            <Textarea placeholder='e.g. Experience at BinaryQubit' {...field} />
                                        </FormControl>
                                        <FormMessage />
                                    </FormItem>
                                )}
                            />

                            <FormField
                                control={form.control}
                                name="rating"
                                render={({ field }) => (
                                    <FormItem>
                                        <FormLabel>Rating ( 0 - 5)</FormLabel>
                                        <FormControl>
                                            <Input type='text' placeholder='Rating Shoud be 0 - 5 ' {...field} />
                                        </FormControl>
                                        <FormMessage />
                                    </FormItem>
                                )}
                            />

                            <div className='flex items-center justify-end'>
                                <Button type='submit'>Add Testimonials</Button>
                            </div>
                        </form>

                    </Form>
                </DialogContent>

            </Dialog>




        </div>
    )
}

export default TestimonialModel