"use client"

import { Button } from "@/components/ui/button"
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from "@/components/ui/dropdown-menu"
import { ColumnDef } from "@tanstack/react-table"
import { Edit, MoreHorizontal, MoreVertical, Trash } from "lucide-react"

// This type is used to define the shape of our data.
// You can use a Zod schema here if you want.
export type testimonials = {
    id: string
    name: string
    designation: string
    message: string
    rating: number
}

export const createColumns = (
    handleEdit: (data: testimonials) => void,
    handleDelete: (data: testimonials) => void
): ColumnDef<testimonials>[] => [
        {
            accessorKey: "name",
            header: "Name",
        },
        {
            accessorKey: "designation",
            header: "Designation",
        },
        {
            accessorKey: "message",
            header: "Message",
            cell: ({ row }) => {

                return <div className=" max-w-[300px] text-wrap">
                    {row.original.message

                    }
                </div>
            }
        },
        {
            accessorKey: "rating",
            header: "Rating"
        },
        {
            header: "Actions",
            id: "actions",
            cell: ({ row }) => (

                <DropdownMenu>
                    <DropdownMenuTrigger asChild>
                        <Button variant="ghost" className="h-8 w-8 p-0">
                            <MoreVertical className="h-4 w-4" />
                        </Button>
                    </DropdownMenuTrigger>
                    <DropdownMenuContent align="end">
                        <DropdownMenuItem onClick={() => handleEdit(row.original)}>
                            <Edit className="h-4 w-4 mr-2" /> Edit
                        </DropdownMenuItem>
                        <DropdownMenuItem onClick={() => handleDelete(row.original)} className="text-red-600">
                            <Trash className="h-4 w-4 mr-2" /> Delete
                        </DropdownMenuItem>
                    </DropdownMenuContent>
                </DropdownMenu>
            ),
        }
    ]


