"use client"
import { Dialog, DialogContent } from "@/components/ui/dialog"
import { DialogTitle } from "@radix-ui/react-dialog"
import React from "react"
import { zodResolver } from "@hookform/resolvers/zod"
import { useForm } from "react-hook-form"
import { z } from "zod"
import { Button } from "@/components/ui/button"
import {
    Form,
    FormControl,
    FormDescription,
    FormField,
    FormItem,
    FormLabel,
    FormMessage,
} from "@/components/ui/form"
import { Input } from "@/components/ui/input"
import { createGallery } from "@/app/api/gallery"

const formSchema = z.object({
    title: z.string().min(2).max(50),
    category: z.string(),
    files: z.array(z.any()).min(1, "At least one image is required"), // Handle multiple files
})

const GalleryDialog = ({ state, onOpenChange }: { state: boolean; onOpenChange: (open: boolean) => void }) => {
    const form = useForm<z.infer<typeof formSchema>>({
        resolver: zodResolver(formSchema),
        defaultValues: {
            title: "",
            category: "",
            files: [],
        },
    })

    const { isSubmitting, isValid } = form.formState
    // Handle form submission
    async function onSubmit(values: z.infer<typeof formSchema>) {
        
        const { success, gallery, error } = await createGallery(values)
     
        // const formData = new FormData()
        // values.files.forEach((file) => formData.append("files", file))

        // const response = await fetch("/api/upload", {
        //     method: "POST",
        //     body: formData,
        // })

        // const data = await response.json()
        // console.log("Uploaded Images:", data.images)
    }

    return (
        <Dialog open={state} onOpenChange={onOpenChange}>
            <DialogContent>
                <DialogTitle>Add Gallery</DialogTitle>
                <Form {...form}>
                    <form onSubmit={form.handleSubmit(onSubmit)} className="space-y-8">
                        {/* Username Input */}
                        <FormField
                            control={form.control}
                            name="title"
                            render={({ field }) => (
                                <FormItem>
                                    <FormLabel>Gallery Title</FormLabel>
                                    <FormControl>
                                        <Input placeholder="shadcn" {...field} />
                                    </FormControl>
                                    <FormDescription>
                                        This is your public display name.
                                    </FormDescription>
                                    <FormMessage />
                                </FormItem>
                            )}
                        />
                        <FormField
                            control={form.control}
                            name="category"
                            render={({ field }) => (
                                <FormItem>
                                    <FormLabel>Type</FormLabel>
                                    <FormControl>
                                        <select {...field} className="border rounded-lg p-2 w-full">
                                            <option value="Workshops">Workshops</option>
                                            <option value="Events">Events</option>
                                            <option value="Others">Others</option>
                                        </select>
                                    </FormControl>
                                    <FormDescription>
                                        This is your public display name.
                                    </FormDescription>
                                    <FormMessage />
                                </FormItem>
                            )}
                        />



                        {/* File Upload */}
                        <FormField
                            control={form.control}
                            name="files"
                            render={({ field }) => (
                                <FormItem>
                                    <FormLabel>Upload Images</FormLabel>
                                    <FormControl>
                                        <Input
                                            type="file"
                                            multiple
                                            accept="image/*"
                                            onChange={(e) => {
                                                const files = e.target.files ? Array.from(e.target.files) : []
                                                form.setValue("files", files) // Manually set files
                                            }}
                                        />
                                    </FormControl>
                                    <FormMessage />
                                </FormItem>
                            )}
                        />

                        {/* Submit Button */}
                        <Button disabled={isSubmitting} type="submit">Submit</Button>
                    </form>
                </Form>
            </DialogContent>
        </Dialog>
    )
}

export default GalleryDialog
