"use client"

import { Course } from "@/app/admin/courses/page"
import { Badge } from "@/components/ui/badge"
import { Button } from "@/components/ui/button"
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from "@/components/ui/dropdown-menu"
import { ColumnDef } from "@tanstack/react-table"
import { Edit, IndianRupee, List, MoreHorizontal, MoreVertical, Trash } from "lucide-react"
import Link from "next/link"

// This type is used to define the shape of our data.
// You can use a Zod schema here if you want.


export const createColumns = (
    handleEdit: (data: Course) => void,
    handleDelete: (data: Course) => void
): ColumnDef<Course>[] => [
        {
            accessorKey: "name",
            header: "Name",
        },
        {
            accessorKey: "description",
            header: "Description",
            cell: ({ row }) => {

                return <div className=" max-w-[300px] text-wrap">
                    {

                        row.original.description

                    }
                </div>
            }
        },
        {
            accessorKey: 'level',
            header: "Level",
            cell: ({ row }) => {
                return <Badge>{row.original.level}</Badge>
            }

        },
        {
            accessorKey: 'categoryId',
            header: "Category",
            cell: ({ row }) => {

                return <Badge>{row.original.category.name}</Badge>
            }

        },


        {
            accessorKey: 'price',
            header: "Price",
            cell: ({ row }) => {
                return <div className="flex items-center">
                    <IndianRupee className="h-4 w-4" /> {row.original.price}
                </div>
            }
        },
        {
            accessorKey: "duration",
            header: "Duration",
            cell: ({ row }) => {
                return <div>
                    {row.original.duration} Hours
                </div>
            }
        },
        {
            header: "Actions",
            id: "actions",
            cell: ({ row }) => (

                <DropdownMenu>
                    <DropdownMenuTrigger asChild>
                        <Button variant="ghost" className="h-8 w-8 p-0">
                            <MoreVertical className="h-4 w-4" />
                        </Button>
                    </DropdownMenuTrigger>
                    <DropdownMenuContent align="end">
                        <Link href={`/admin/courses/${row.original.id}/sections`}>
                            <DropdownMenuItem>

                                <List className="h-4 w-4 mr-2" /> View / Add Sections

                            </DropdownMenuItem>
                        </Link>
                        <DropdownMenuItem onClick={() => handleEdit(row.original)}>
                            <Edit className="h-4 w-4 mr-2" /> Edit Course
                        </DropdownMenuItem>
                        <DropdownMenuItem onClick={() => handleDelete(row.original)} className="text-red-600">
                            <Trash className="h-4 w-4 mr-2" /> Delete Course
                        </DropdownMenuItem>
                    </DropdownMenuContent>
                </DropdownMenu>
            ),
        }
    ]


