"use client"
import { createClient } from '@/app/api/clients'
import { Button } from '@/components/ui/button'
import { Dialog, DialogContent, DialogDescription, DialogHeader, DialogTitle } from '@/components/ui/dialog'
import { Form, FormControl, FormField, FormItem, FormLabel, FormMessage } from '@/components/ui/form'
import { Input } from '@/components/ui/input'
import { zodResolver } from '@hookform/resolvers/zod'


import React from 'react'
import { useForm } from 'react-hook-form'


import { z } from "zod"

const formSchema = z.object({
    name: z.string().min(2).max(50),
    logo: z.any()
})

const ClientModel = ({ open, onOpenChange }: { open: boolean, onOpenChange: (open: boolean) => void }) => {
    const form = useForm<z.infer<typeof formSchema>>({
        resolver: zodResolver(formSchema),
        defaultValues: {
            name: "",
            logo: ""
        }
    })

    const onSubmit = async (values: z.infer<typeof formSchema>) => {
        const { client, error } = await createClient(values)
        if (!error && client) {
            onOpenChange(false)
            window.location.reload()
        } else {
            console.log(error)
        }
    }
    return (
        <div>
            <Dialog open={open} onOpenChange={onOpenChange}>
                <DialogContent>
                    <DialogHeader>
                        <DialogTitle>Add New Client</DialogTitle>
                        <DialogDescription></DialogDescription>
                    </DialogHeader>
                    <Form {...form}>
                        <form onSubmit={form.handleSubmit(onSubmit)} className='space-y-6'>
                            <FormField
                                control={form.control}
                                name="name"
                                render={({ field }) => (
                                    <FormItem>
                                        <FormLabel>Client Name</FormLabel>
                                        <FormControl>
                                            <Input type='text' placeholder='e.g.  Microsoft' {...field} />
                                        </FormControl>
                                        <FormMessage />
                                    </FormItem>
                                )}
                            />

                            <FormField
                                control={form.control}
                                name="logo"
                                render={({ field: { onChange, ...field } }) => (
                                    <FormItem>
                                        <FormLabel>Client logo</FormLabel>
                                        <FormControl>
                                            <Input type="file"
                                                accept="image/*"
                                                onChange={(e) => {
                                                    const file = e.target.files?.[0];
                                                    onChange(file);  // ✅ Store the File object
                                                }} />
                                        </FormControl>
                                        <FormMessage />
                                    </FormItem>
                                )}
                            />
                            <div className='flex items-center justify-end'>
                                <Button type='submit'>Add Client</Button>
                            </div>
                        </form>

                    </Form>
                </DialogContent>

            </Dialog>




        </div>
    )
}

export default ClientModel