'use client'
import { Button } from "@/components/ui/button";
import { motion } from "framer-motion";
import { ArrowRight } from "lucide-react";

const CallToAction = () => {
    return (
        <div className="relative bg-[#1a1d29] text-white overflow-hidden">
            <div className="max-w-7xl mx-auto px-6 lg:px-8">
                <div className="grid grid-cols-1 md:grid-cols-2 items-center min-h-[500px]">
                    <div className="max-w-2xl space-y-6">
                        <motion.h2
                            className="text-5xl font-bold tracking-tight sm:text-6xl"
                            initial={{ opacity: 0, y: -20 }}
                            animate={{ opacity: 1, y: 0 }}
                            transition={{ duration: 0.6 }}
                        >
                            Master AI & Web Development with BinaryQubit
                        </motion.h2>
                        <motion.p
                            className="text-lg text-gray-300"
                            initial={{ opacity: 0 }}
                            animate={{ opacity: 1 }}
                            transition={{ duration: 0.8 }}
                        >
                            Join expert-led courses in AI, Machine Learning, and Web Development to advance your career in tech. Your future starts here.
                        </motion.p>
                        <motion.div
                            initial={{ opacity: 0, scale: 0.8 }}
                            animate={{ opacity: 1, scale: 1 }}
                            transition={{ duration: 0.6 }}
                        >
                            <Button className="px-8 py-4 text-lg font-semibold bg-indigo-500 hover:bg-indigo-600 rounded-lg shadow-lg" variant="default">
                                Get Started <ArrowRight className="ml-2 w-5 h-5" />
                            </Button>
                        </motion.div>
                    </div>
                    <div className="flex justify-center p-6">
                        <motion.img
                            src="/upload/banner/CTA.png"
                            alt="BinaryQubit Training"
                            className="w-full max-w-lg rounded-lg shadow-2xl"
                            initial={{ opacity: 0, scale: 0.9 }}
                            animate={{ opacity: 1, scale: 1 }}
                            transition={{ duration: 0.8 }}
                        />
                    </div>
                </div>
            </div>
        </div>
    );
}

export default CallToAction
