import { LoginForm } from "@/components/login-form"
import { getSession } from "../api/actions"
import { redirect } from "next/navigation"

export default async function LoginPage() {
  const session = await getSession()
  if (session.islogged && session.role === "admin") {
    return redirect("/admin")
  }
  return (
    <div className="bg-muted flex min-h-svh flex-col items-center justify-center p-6 md:p-10">
      <div className="w-full max-w-sm md:max-w-3xl">
        <LoginForm />
      </div>
    </div>
  )
}
